Attribute VB_Name = "Trig_Deg"
Const Pi = 3.14159265358979

Public Function ArcSine(ToBeCalculated As Variant) As Double
'On Error GoTo ERROR_ArcSine                                     ' Trap strangeness.

Const cOVERFLOW = 6                                             ' "Overflow" message #.

Dim blnEditPassed As Boolean                                    ' Edit results variable.
Dim dblTemp       As Double                                     ' Temporary double.

    blnEditPassed = False                                       ' It hasn't passed yet!
    If IsNumeric(ToBeCalculated) Then                                  ' Is arg numeric?
        If ToBeCalculated >= -1 And ToBeCalculated <= 1 Then                  ' Yup, is it within limits?
            blnEditPassed = True                                ' Yup, employ Derived Math Function:
                                                                ' Arcsin(X) = Atn(X / Sqr(-X * X + 1))
            dblTemp = Sqr(-ToBeCalculated * ToBeCalculated + 1)               ' Calculate denominator.
            If dblTemp = 0 Then                                 ' Is it 0?  Can only happen if arg is +1 or -1.
                ArcSine = Sgn(ToBeCalculated) * Pi / 2          ' Yup, assign +Pi/2 or -Pi/2 based on sign of arg.
            Else
                ArcSine = Atn(ToBeCalculated / dblTemp)           ' Complete derived math function.
            End If
        End If
    End If

ArcSine = ArcSine * 180 / Pi

EXIT__ArcSine:
    If Not blnEditPassed Then Err.Raise cOVERFLOW               ' Raise overflow error if arg failed edits.
    Exit Function

ERROR_ArcSine:
    On Error GoTo 0                                             ' Turn off error trapping.
    blnEditPassed = False                                       ' Should never happen!
    Resume EXIT__ArcSine                                        ' But if it does give overflow error.

End Function

Public Function ArcCosine(Vari As Variant) As Double
ArcCosine = -ArcSine(Vari) + 90
End Function

Public Function ArcTan(Vari As Variant) As Double
ArcTan = Atn(Vari) * 180 / Pi
End Function

Public Function Deg(Radiant As Variant) As Double
Deg = Radiant * 180 / Pi
End Function

Public Function Rad(Degrees As Variant) As Double
Rad = Degrees * Pi / 180
End Function

